#!/bin/bash

#
# Version 1.2
#
### Usage :
#
# -h : HOST/IP
# -u : USERNAME
# -p : PASSWORD
# -s : Shared (default : 1)
#
# example : ./vncstart -h 192.168.0.115 -u user -p PASSWORD -s 0
#
###

# Default Value
varTMP="tmp.vnc"
varUSERNAME="root"
varSHARED="1"
varPATH="/custom/VNC-Viewer"

varERROR="FALSE"


# Getting Entry
while getopts ":h:u:p:s:" optname
  do
    case "$optname" in    
      "h")
	varHOST=$OPTARG
        ;;
      "u")
        varUSERNAME="$OPTARG"
        ;;
      "p")
	varPASSWORD=$OPTARG
        ;;
      "s")
        varSHARED=$OPTARG
        ;;
      "?")
        echo "Unknown option $OPTARG"
        ;;
      ":")
        echo "No argument value for option $OPTARG"
	varERROR="TRUE"
        ;;
      *)
      # Should not occur
        echo "Unknown error while processing options"
        ;;
    esac
  done

if [[ -z "${varHOST}" ]]; then
  echo "Option Missing: -h HOST/IP"
  varERROR="TRUE"
fi
if [[ -z "${varPASSWORD}" ]]; then
  echo "Option Missing: -p PASSWORD"
  varERROR="TRUE"
fi

if [[ $varERROR == "TRUE" ]]; then
  exit
fi

#echo "Host = $varHOST"
#echo "Username = $varUSERNAME"
#echo "Password = $varPASSWORD"
#echo "Shared = $varSHARED"

#exit
#echo "Bulding .VNC file"

cd $varPATH
echo "[Connection]" > $varTMP
echo "Host=$varHOST" >> $varTMP
echo "UserName=$varUSERNAME" >> $varTMP
echo "Password=$varPASSWORD" >> $varTMP
echo "Identity=" >> $varTMP
echo "Encryption=Server" >> $varTMP
echo "SecurityNotificationTimeout=2500" >> $varTMP
echo "SelectDesktop=" >> $varTMP
echo "ProxyServer=" >> $varTMP
echo "ProxyType=" >> $varTMP
echo "ProxyUserName=" >> $varTMP
echo "ProxyPassword=" >> $varTMP
echo "SingleSignOn=1" >> $varTMP
echo "[Options]" >> $varTMP
echo "UseLocalCursor=1" >> $varTMP
echo "FullScreen=1" >> $varTMP
echo "RelativePtr=0" >> $varTMP
echo "FullColour=1" >> $varTMP
echo "ColourLevel=pal8" >> $varTMP
echo "PreferredEncoding=ZRLE" >> $varTMP
echo "AutoSelect=1" >> $varTMP
echo "Shared=$varSHARED" >> $varTMP
echo "SendPointerEvents=1" >> $varTMP
echo "SendKeyEvents=1" >> $varTMP
echo "ClientCutText=1" >> $varTMP
echo "ServerCutText=1" >> $varTMP
echo "ShareFiles=1" >> $varTMP
echo "EnableChat=1" >> $varTMP
echo "EnableRemotePrinting=1" >> $varTMP
echo "ChangeServerDefaultPrinter=1" >> $varTMP
echo "PointerEventInterval=0" >> $varTMP
echo "PointerCornerSnapThreshold=30" >> $varTMP
echo "Scaling=None" >> $varTMP
echo "MenuKey=F8" >> $varTMP
echo "EnableToolbar=1" >> $varTMP
echo "AutoReconnect=1" >> $varTMP
echo "Protocol3.3=0" >> $varTMP
echo "AcceptBell=1" >> $varTMP
echo "ScalePrintOutput=1" >> $varTMP
echo "PasswordFile=" >> $varTMP
echo "VerifyId=0" >> $varTMP
echo "IdHash=" >> $varTMP
echo "WarnUnencrypted=0" >> $varTMP
echo "DotWhenNoCursor=1" >> $varTMP
echo "SendPrimary=1" >> $varTMP
./VNC-Viewer-x86 -config $varTMP
rm $varTMP
