#!/bin/bash

#
# Version 1.2
#
### Usage :
#
# -h : HOST/IP
# -u : USERNAME
# -p : PASSWORD
# -s : Shared (default : 1)
#
# example : ./vncstart -h 192.168.0.115 -u user -p PASSWORD -s 0
#
###

# Default Value
varTMP="passwd"
varUSERNAME="root"
varSHARED="1"
varPATH="/custom/TigerVNC"

varERROR="FALSE"


# Getting Entry
while getopts ":h:u:p:s:" optname
  do
    case "$optname" in    
      "h")
	varHOST=$OPTARG
        ;;
      "u")
        varUSERNAME="$OPTARG"
        ;;
      "p")
	varPASSWORD=$OPTARG
        ;;
      "s")
        varSHARED=$OPTARG
        ;;
      "?")
        echo "Unknown option $OPTARG"
        ;;
      ":")
        echo "No argument value for option $OPTARG"
	varERROR="TRUE"
        ;;
      *)
      # Should not occur
        echo "Unknown error while processing options"
        ;;
    esac
  done

if [[ -z "${varHOST}" ]]; then
  echo "Option Missing: -h HOST/IP"
  varERROR="TRUE"
fi
if [[ -z "${varPASSWORD}" ]]; then
  echo "Option Missing: -p PASSWORD"
  varERROR="TRUE"
fi

if [[ $varERROR == "TRUE" ]]; then
  exit
fi

#echo "Host = $varHOST"
#echo "Username = $varUSERNAME"
#echo "Password = $varPASSWORD"
#echo "Shared = $varSHARED"

#exit
#echo "Bulding .VNC file"

cd $varPATH
printf "$varPASSWORD\n$varPASSWORD\n\n" | $varPATH/vncpasswd $varPATH/$varTMP 
./vncviewer -FullScreen -FullScreenAllMonitors -passwd $varTMP $varHOST 
rm $varTMP
#sleep 10